//
//  CameraViewController.m
//  Camera
//
//  Created by Robert Górczyński on 11-07-30.
//

#import "CameraViewController.h"
#import <MobileCoreServices/UTCoreTypes.h> 

@interface CameraViewController () 
static UIImage *shrinkImage(UIImage *original, CGSize size); 
- (void)updateDisplay; 
- (void)getMediaFromSource:(UIImagePickerControllerSourceType)sourceType; 
@end 

@implementation CameraViewController
@synthesize imageView; 
@synthesize takePictureButton; 
@synthesize moviePlayerController; 
@synthesize image; 
@synthesize movieURL; 
@synthesize lastChosenMediaType; 

- (void)viewDidLoad { 
    if (![UIImagePickerController isSourceTypeAvailable: 
          UIImagePickerControllerSourceTypeCamera]) { 
        takePictureButton.hidden = YES;
    } 
    imageFrame = imageView.frame;
} 

- (void)viewDidAppear:(BOOL)animated { 
    [super viewDidAppear:animated]; 
    [self updateDisplay]; 
} 


- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
    self.imageView = nil; 
    self.takePictureButton = nil; 
    self.moviePlayerController = nil; 
    [super viewDidUnload]; 	
}


- (void)dealloc {
    [imageView release]; 
    [takePictureButton release]; 
    [moviePlayerController release]; 
    [image release]; 
    [movieURL release]; 
    [lastChosenMediaType release];	
    [super dealloc];
}

- (IBAction)shootPictureOrVideo:(id)sender { 
    [self getMediaFromSource:UIImagePickerControllerSourceTypeCamera]; 
} 

- (IBAction)selectExistingPictureOrVideo:(id)sender { 
    [self getMediaFromSource:UIImagePickerControllerSourceTypePhotoLibrary]; 
}

#pragma mark UIImagePickerController delegate methods 
- (void)imagePickerController:(UIImagePickerController *)picker  
didFinishPickingMediaWithInfo:(NSDictionary *)info { 
    self.lastChosenMediaType = [info objectForKey:UIImagePickerControllerMediaType]; 
    if ([lastChosenMediaType isEqual:(NSString *)kUTTypeImage]) { 
        UIImage *chosenImage = [info objectForKey:UIImagePickerControllerEditedImage]; 
        UIImage *shrunkenImage = shrinkImage(chosenImage, imageFrame.size); 
        self.image = shrunkenImage; 
    } else if ([lastChosenMediaType isEqual:(NSString *)kUTTypeMovie]) { 
        self.movieURL = [info objectForKey:UIImagePickerControllerMediaURL]; 
    } 
    [picker dismissModalViewControllerAnimated:YES]; 
} 

- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker {     
    [picker dismissModalViewControllerAnimated:YES]; 
}

#pragma mark  - 
static UIImage *shrinkImage(UIImage *original, CGSize size) { 
    CGFloat scale = [UIScreen mainScreen].scale; 
    CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB(); 
	
    CGContextRef context = CGBitmapContextCreate(NULL, size.width * scale, 
												 size.height * scale, 8, 0, colorSpace, kCGImageAlphaPremultipliedFirst); 
    CGContextDrawImage(context,
					   CGRectMake(0, 0, size.width * scale, size.height * scale), 
					   original.CGImage); 
    CGImageRef shrunken = CGBitmapContextCreateImage(context); 
    UIImage *final = [UIImage imageWithCGImage:shrunken]; 
	
    CGContextRelease(context); 
    CGImageRelease(shrunken);    
	
    return final; 
}

- (void)updateDisplay { 
    if ([lastChosenMediaType isEqual:(NSString *)kUTTypeImage]) { 
        imageView.image = image; 
        imageView.hidden = NO; 
        moviePlayerController.view.hidden = YES; 
    } else if ([lastChosenMediaType isEqual:(NSString *)kUTTypeMovie]) { 
        [self.moviePlayerController.view removeFromSuperview]; 
        self.moviePlayerController = [[[MPMoviePlayerController alloc] 
									   initWithContentURL:movieURL] autorelease]; 
        moviePlayerController.view.frame = imageFrame; 
        moviePlayerController.view.clipsToBounds = YES; 
        [self.view addSubview:moviePlayerController.view]; 
        imageView.hidden = YES; 
    } 
}

- (void)getMediaFromSource:(UIImagePickerControllerSourceType)sourceType { 
    NSArray *mediaTypes = [UIImagePickerController 
						   availableMediaTypesForSourceType:sourceType]; 
    if ([UIImagePickerController isSourceTypeAvailable: 
         sourceType] && [mediaTypes count] > 0) { 
        NSArray *mediaTypes = [UIImagePickerController 
							   availableMediaTypesForSourceType:sourceType]; 
        UIImagePickerController *picker = 
        [[UIImagePickerController alloc] init]; 
        picker.mediaTypes = mediaTypes; 
        picker.delegate = self; 
        picker.allowsEditing = YES; 
        picker.sourceType = sourceType; 
        [self presentModalViewController:picker animated:YES]; 
        [picker release]; 
    } 
    else { 
        UIAlertView *alert = [[UIAlertView alloc]  
							  initWithTitle:@"Błąd podczas pobierania danych"  
							  message:@"Urządzenie nie obsługuje wybranego źródła danych."  
							  delegate:nil  
							  cancelButtonTitle:@"A niech to!"  
							  otherButtonTitles:nil]; 
        [alert show]; 
        [alert release]; 
    } 
} 

@end
